#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

// Funkcija koja izracunava maksimalnu velicinu vojske za dati nivo
int maksimalnaVelicinaVojske(int N, int S, vector<int>& mi, vector<int>& ai, vector<int>& li, vector<int>& ri) {
    vector<int> velicinaVojske(N + 1, 0);
    velicinaVojske[0] = S;

    for (int i = 0; i < N; i++) {
        // Prva opcija: *
        int novaVelicina1 = velicinaVojske[i] * mi[i];
        if (novaVelicina1 >= li[i] && novaVelicina1 <= ri[i]) {
            velicinaVojske[i + 1] = max(velicinaVojske[i + 1], novaVelicina1);
        }

        // Druga opcija: +
        int novaVelicina2 = velicinaVojske[i] + ai[i];
        if (novaVelicina2 >= li[i] && novaVelicina2 <= ri[i]) {
            velicinaVojske[i + 1] = max(velicinaVojske[i + 1], novaVelicina2);
        }

        //  negativ. vrednost
        if (velicinaVojske[i + 1] < 0) {
            velicinaVojske[i + 1] = 0;
        }
    }

    return (velicinaVojske[N] > 0) ? velicinaVojske[N] : -1;
}

int main() {
    int T;
    cin >> T;

    for (int t = 0; t < T; t++) {
        int N, S;
        cin >> N >> S;

        vector<int> mi(N), ai(N), li(N), ri(N);

        for (int i = 0; i < N; i++) {
            cin >> mi[i];
        }

        for (int i = 0; i < N; i++) {
            cin >> ai[i];
        }

        for (int i = 0; i < N; i++) {
            cin >> li[i];
        }

        for (int i = 0; i < N; i++) {
            cin >> ri[i];
        }

        int rezultat = maksimalnaVelicinaVojske(N, S, mi, ai, li, ri);

        if (rezultat >= 0) {
            cout << rezultat << endl;
        } else {
            cout << "nemoguce" << endl;
        }
    }

    return 0;
}